Attribute VB_Name = "TimeZoneInformation"
Option Compare Database
Option Explicit

Private Const TIME_ZONE_ID_UNKNOWN = 0
Private Const TIME_ZONE_ID_STANDARD = 1
Private Const TIME_ZONE_ID_DAYLIGHT = 2

Private Type SYSTEMTIME
    wYear         As Integer
    wMonth        As Integer
    wDayOfWeek    As Integer
    wDay          As Integer
    wHour         As Integer
    wMinute       As Integer
    wSecond       As Integer
    wMilliseconds As Integer
End Type

Private Type TIME_ZONE_INFORMATION
  Bias As Long
  StandardName(62) As Byte
  StandardDate As SYSTEMTIME
  StandardBias As Long
  DaylightName(62) As Byte
  DaylightDate  As SYSTEMTIME
  DaylightBias As Long
End Type

Private Declare PtrSafe Function GetTimeZoneInformation Lib "Kernel32" _
                (ByRef lpTimeZoneInformation As TIME_ZONE_INFORMATION) As Long
  
  
Public Sub DisplayTimezoneInformation()

    Dim TimeZoneInfo As String
    Dim DaylightTimeName As String
    Dim StandardTimeName As String
    Dim apiRetVal As Long
    Dim errorCode As Long
    
    Dim tzi As TIME_ZONE_INFORMATION
    
    apiRetVal = GetTimeZoneInformation(tzi)
    errorCode = Err.LastDllError
   
    DaylightTimeName = GetTimeName(tzi.DaylightName)
    StandardTimeName = GetTimeName(tzi.StandardName)
    
    Select Case apiRetVal
        Case TIME_ZONE_ID_DAYLIGHT
            TimeZoneInfo = "Time Name: " & DaylightTimeName & vbCrLf & vbCrLf & _
                            "Offset from local Standard time: " & tzi.DaylightBias * -1 & " minutes" & vbCrLf & _
                            "Offset from UTC: " & (tzi.Bias + tzi.DaylightBias) * -1 & " minutes" & vbCrLf & vbCrLf & _
                            "Current local Time: " & Now() & vbCrLf & _
                            "Current UTC Time: " & DateAdd("n", tzi.Bias + tzi.DaylightBias, Now()) & vbCrLf & vbCrLf & _
                            "Transition to " & StandardTimeName & " will happen on the " & GetOccuranceText(tzi.StandardDate.wDay) & _
                                            " " & WeekdayName(tzi.StandardDate.wDayOfWeek + 1, False, vbSunday) & _
                                            " of " & MonthName(tzi.StandardDate.wMonth) & _
                                            " at " & Format(tzi.StandardDate.wHour & ":" & tzi.StandardDate.wMinute, "Short Time") & " o'clock"

        Case TIME_ZONE_ID_STANDARD
            TimeZoneInfo = "Time Name: " & StandardTimeName & vbCrLf & vbCrLf & _
                            "Offset from local Standard time: " & tzi.StandardBias * -1 & " minutes" & vbCrLf & _
                            "Offset from UTC: " & (tzi.Bias + tzi.StandardBias) * -1 & " minutes" & vbCrLf & vbCrLf & _
                            "Current local Time: " & Now() & vbCrLf & _
                            "Current UTC Time: " & DateAdd("n", tzi.Bias + tzi.StandardBias, Now()) & vbCrLf & vbCrLf & _
                            "Transition to " & DaylightTimeName & " will happen on the " & GetOccuranceText(tzi.DaylightDate.wDay) & _
                                            " " & WeekdayName(tzi.DaylightDate.wDayOfWeek + 1, False, vbSunday) & _
                                            " of " & MonthName(tzi.DaylightDate.wMonth) & _
                                            " at " & Format(tzi.DaylightDate.wHour & ":" & tzi.DaylightDate.wMinute, "Short Time") & " o'clock"

        Case TIME_ZONE_ID_UNKNOWN
            TimeZoneInfo = "Time Name: " & StandardTimeName & vbCrLf & vbCrLf & _
                            "Offset from UTC: " & (tzi.Bias + tzi.StandardBias) * -1 & " minutes" & vbCrLf & vbCrLf & _
                            "Current local Time: " & Now() & vbCrLf & _
                            "Current UTC Time: " & DateAdd("n", tzi.Bias + tzi.DaylightBias, Now()) & vbCrLf & vbCrLf & _
                            "(There is no information about Daylight Savings Time)"

        Case Else
            TimeZoneInfo = "Unable to retrieve time zone information due to an error. (Windows API error code: " & errorCode & ")"
    End Select
    
    MsgBox TimeZoneInfo, vbOKOnly, "Time Zone Information"
    
End Sub

Private Function GetOccuranceText(ByVal NumericOccurance As Integer) As String
    Dim retVal As String
    If NumericOccurance = 5 Then
        retVal = "last"
    Else
        retVal = NumericOccurance & "."
    End If
    GetOccuranceText = retVal
End Function

Private Function GetTimeName(TimeZoneBytes() As Byte) As String
    GetTimeName = Left(CStr(TimeZoneBytes), InStr(CStr(TimeZoneBytes), vbNullChar) - 1)
End Function

Private Function SystemTimeToDateTime(SysTime As SYSTEMTIME) As Date
    With SysTime
        SystemTimeToDateTime = DateSerial(.wYear, .wMonth, .wDay) + TimeSerial(.wHour, .wMinute, .wSecond)
    End With
End Function



